/******************************************************************************
 * %Id: tcon_bridge_data.h,v 1.4 2009/01/19 11:29:51 iinuma Exp $
 *
 * FileName		:tcon_bridge_data.h
 *
 * Description	:Definition header of data used in bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_TCON_BRIDGE_DATA_H_
#define	_TCON_BRIDGE_DATA_H_

#include <linux/iosc/iosc-devices.h>

#define TCON_MAX_FD_NAME                256

/*
 * Sub Structs
 */

typedef struct {
	int	cmd;
	int	(*handler) (int, unsigned int, void *);
} tcon_command_t;

/**************/
typedef struct {
	int	error;
} tcon_arg_t;

typedef tcon_arg_t		tcon_void_arg_t;

typedef struct {
	int	error;
	unsigned char sel;
} tcon_init_arg_t;

typedef tcon_void_arg_t		tcon_term_arg_t;

typedef struct _tcon_status_arg_t {
	int	error;
	unsigned char	state;
} tcon_status_arg_t;

typedef tcon_void_arg_t		tcon_configuration_arg_t;

typedef struct _vop_start_powon_arg_t {
	int	error;
	unsigned char frame;
} tcon_start_powon_arg_t;

typedef tcon_void_arg_t		tcon_start_powoff_arg_t;


/**************/
#endif /* _TCON_BRIDGE_DATA_H_ */
/* end of tcon_bridge_data.h */
